#!/c/Perl/bin//perl -w
#
# $Id: namazu-cgi-7.pl.in,v 1.1.4.3 2006/01/10 19:37:18 opengl2772 Exp $
# Copyright (C) 2004-2006 Tadamasa Teranishi
#               2004-2006 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#
#  This file must be encoded in EUC-JP encoding
#
#

#
# Test for DOCUMENT_NAME variable
#

use strict;
require Cwd;
require 'pltests.pl';

my $cwd = Cwd::cwd();
my $LOG = "$cwd/test-log";
my $INDEX = "$cwd/idx19";
my $NAMAZU = pltests::binpath('namazu.cgi');
my $RC = pltests::binpath('.namazurc');

my @cmd;

delete $ENV{'LANG'};
$ENV{'LANGUAGE'} = 'C';
$ENV{'LC_ALL'} = 'C';
delete $ENV{'LC_MESSAGE'};
delete $ENV{'LC_CTYPE'};
delete $ENV{'NAMAZURC'};

$ENV{'SERVER_SOFTWARE'} = 'Microsoft-';
$ENV{'SCRIPT_NAME'} = 'namazu.cgi';

pltests::putline($LOG, "  *** starting $0");

if (-f $RC) {
    unlink("$RC");
}
pltests::putline($RC, "Index $INDEX");
pltests::duprcs($RC);

$ENV{'QUERY_STRING'} = '';

@cmd = ("$NAMAZU");
my ($status, $result, $conts_err) = pltests::ezsyscmd(\@cmd);
unless (defined $result) {
    pltests::putline($LOG, "\"$result\"");
    exit 1;
}

my $count = 0;
foreach my $line (split(/\n/, $result)) {
    my $pattern = quotemeta($ENV{'SCRIPT_NAME'});
    if ($line =~ /$pattern/) {
        $count++;
    }
}

pltests::putline($LOG, "QUERY_STRING='" . $ENV{'QUERY_STRING'} . "' count: $count");

if ($count != 2) {
    pltests::putline($LOG, "\"$result\"");
    exit 1;
}

$ENV{'QUERY_STRING'} = 'query=namazu';

@cmd = ("$NAMAZU");
($status, $result, $conts_err) = pltests::ezsyscmd(\@cmd);
unless (defined $result) {
    exit 1;
}

$count = 0;
foreach my $line (split(/\n/, $result)) {
    my $pattern = quotemeta($ENV{'SCRIPT_NAME'});
    if ($line =~ /$pattern/) {
        $count++;
    }
}

pltests::putline($LOG, "QUERY_STRING='" . $ENV{'QUERY_STRING'} . "' count: $count");

if ($count != 3) {
    exit 1;
}

exit 0;

END {
    if (-f $RC) {
        unlink("$RC");
    }
}
